/*
  Project: Sicherungsverteiler Pro mit ACS712-Sensoren und Arduino-Auswertung
  Author: Michael Todtenbier
  Date: Created 17.08.2024
  Version: V1.2
  IDE: Arduino IDE 1.8.19
 
  ACS712 Sensor:   Wolfgang Ewald for https://wolles-elektronikkiste.de/
  Website:         https://wolles-elektronikkiste.de/acs712-stromsensor
  FastLED Part:    Michael Todtenbier
  Website:         https://wiki.mobaledlib.de/anleitungen/bauanleitungen/sicherungsverteiler_pro_221de
                   Bitte die Anleitung im Wiki beachten!
 
  Der Sketch ueberwacht bis zu acht ACS712-Sensoren an den analogen Eingangs-Pins.
  Ueber das integrierte ST7735-Display werden die aktuellen Stromverbraeuche der acht Kanaele angezeigt.
  Zusaetzlich koennen an Pin D6 bis zu acht WS2812 LEDs angeschlossen werden.
  Diese LEDs signalisieren per Ampel-System den aktuellen Stromverbrauch.
  Die Grenzen zwischen gruen/gelb und gelb/rot werden als Variablen current_a und current_b definiert.


  Modified by Dominik 2025-06-07 17:30 wegen Displayplatine
  Modified by Holger Loges 2025-12-17 automatische Spannungserkennung gegen Festparameter in "Definitions.h" geändert
*/
 
#include <FastLED.h>
#include <SPI.h>
#include <EEPROM.h>
#include "Ucglib.h"

#define TASTER_1_PIN 2
#define TASTER_2_PIN 3
#define TASTER_3_PIN 4
#define DATA_PIN 6 // Pin für WS2812 LEDs
const byte NUM_LEDS = 16; // Anzahl der WS2812-LEDs - modified Dominik 2025-06-07 17:30 wegen Displayplatine
// This is an array of leds. One item for each led in your strip.
CRGB leds[NUM_LEDS];
Ucglib_ST7735_18x128x160_HWSPI ucg(/*cd=*/ 9, /*cs=*/ 10, /*reset=*/ 8);
 
const int ACS712_Pin0 = A0;
const int ACS712_Pin1 = A1;
const int ACS712_Pin2 = A2;
const int ACS712_Pin3 = A3;
const int ACS712_Pin4 = A4;
const int ACS712_Pin5 = A5;
const int ACS712_Pin6 = A6;
const int ACS712_Pin7 = A7;
 
// Hier stehen die Standard-Werte der acht ACS712-Sensoren.
// Zum Kalibrieren werden die Tasten „Hoch“ & „Runter“ bei eingeschalteter Versorgungsspannung für ca. eine Sekunde lang gleichzeitig gedrückt.
// Dabei misst der Arduino die Abweichung ggü. Null und schreibt die gemessenen Werte dauerhaft ins EEPROM.
float zeroCurrentValue[] =
             {
              512,   // Fuse1
              512,   // Fuse2
              512,   // Fuse3
              512,   // Fuse4
              512,   // Fuse5 
              512,   // Fuse6
              512,   // Fuse7  
              512,   // Fuse8
             };
 
// #include "Name.h"    // In dieser Datei wird der im Display angezeigte Name definiert.
#include "Definitions.h"    // In dieser Datei wird der im Display angezeigte Name und die Spannung definiert.
#include "Colors.h"  // In dieser Datei werden die verwendeten Farben für die LEDs und die Schrift definiert.

// Einzelne Bereiche des Stromverbrauchs
#define current_a 0.8
#define current_b 1.2
#define currentfuse -0.5

bool First = true;
char checkname[]="ACS712-Display";

void set_EEPROM_OK()
//Schreibt ins EEPRO den Namen in der variable checkname
//Dieser Name wird verwendet von der Funktion is_EEPROM_OK
{
  int i;
  for(i=0; i<sizeof(checkname)-1; i++)
    {
      Serial.println((int)checkname[i]);
      EEPROM.update(i, checkname[i]);
    }
}

bool is_EEPROM_OK()  // Prueft, ob der der richtige Name am Anfang des EEPROMs steht.
{
  int i;
  for(i=0; i<sizeof(checkname)-1; i++)
    {
      if(EEPROM.read(i)!= checkname[i])
        {
          return false;
        }
    }
  return true;
}

void calc_zeroCurrentValue()
{
  for(int Channel = 0; Channel <= 7; Channel++) 
      {
      int Oversampling=1000;
      long rawValue = 0;
      for(int i=0; i<Oversampling; i++)
        { // 10-12ms bei 100 Messungen
        rawValue += analogRead(ACS712_Pin0 + Channel);
        }
      zeroCurrentValue[Channel] = (float)rawValue/Oversampling;
      Serial.print("zeroCurrentValue[");
      Serial.print(Channel);
      Serial.print("]=");
      Serial.println(zeroCurrentValue[Channel]);
      }
}

void write_zeroCurrentValue()                     // Schreibt zeroCurrentValue ins EEPROM 
{
  int i;
  int adress=sizeof(checkname)-1;
  // zeroCurrentValue hat 8 Elemente und jedes Elemnt ist ein Float, ein Float ist 4 Byte
  for(i=0; i<sizeof(zeroCurrentValue)/sizeof(zeroCurrentValue[0]); i++)
    {
      //Serial.println((int)checkname[i]);
      EEPROM.put(adress, zeroCurrentValue[i]);
      adress=adress+sizeof(zeroCurrentValue[0]);  // Adresse an die naechste Speicherstelle setzen.
    }
}

 void read_zeroCurrentValue()
//liesst zeroCurrentValue aus eeprom 
{
  int i;
  int adress=sizeof(checkname)-1;                 // zeroCurrentValue hat 8 Elemente und jedes Elemnt ist ein Float, ein Float ist 4 Byte
  for(i=0; i<sizeof(zeroCurrentValue)/sizeof(zeroCurrentValue[0]); i++)
    {
      //Serial.println((int)checkname[i]);
      EEPROM.get(adress, zeroCurrentValue[i]);
      adress=adress+sizeof(zeroCurrentValue[0]);  // Adresse an die naechste Speicherstelle setzen.
      Serial.println(zeroCurrentValue[i]);
    }
}


void setup() {
  Serial.begin(57600);
  pinMode(TASTER_1_PIN,INPUT_PULLUP);
  pinMode(TASTER_2_PIN,INPUT_PULLUP);
  pinMode(TASTER_3_PIN,INPUT_PULLUP);
//set_EEPROM_OK();
//calc_zeroCurrentValue();
//write_zeroCurrentValue();
  if (is_EEPROM_OK())
    read_zeroCurrentValue();
  else Serial.println("Nullwerte nicht kalibriert");
    {
    read_zeroCurrentValue[0];
      if (zeroCurrentValue[0]>515)  // HLO increase value from 505 to 515
        {
        Serial.println("5V Netzteil angeschlossen");
        }
       else
        {
        Serial.println("12V  Netzteil angeschlossen");
        }
   }
//  Serial.print ("is_EEPROM_OK():");
//  Serial.println(is_EEPROM_OK());
//  Serial.println(calc_zeroCurrentValue);
  
  //FastLED aktivieren
  FastLED.addLeds<WS2811, DATA_PIN, GRB>(leds, NUM_LEDS);

  delay(1000);
  //ucg.begin(UCG_FONT_MODE_TRANSPARENT);
  ucg.begin(UCG_FONT_MODE_SOLID);
  ucg.clearScreen();
  ucg.setRotate90();
  ucg.drawHLine(0, 21, 160);
  ucg.drawHLine(0, 48, 160);
  ucg.drawHLine(0, 75, 160);
  ucg.drawHLine(0, 102, 160);
  ucg.drawVLine(80, 0, 102);

}

uint16_t Cnt = 0;
float Sum;
float Avg;


void loop() 
{
  if(digitalRead(TASTER_1_PIN)==0 && digitalRead(TASTER_3_PIN)==0)
    {
      calc_zeroCurrentValue();
      write_zeroCurrentValue();
      set_EEPROM_OK();
    }

  float TotalCurrent = 0;
  for(int Channel = 0; Channel <= 7; Channel++) 
  
      {
      #define Oversampling 400  
      long rawValue = 0;
      for(int i=0; i<Oversampling; i++){ // 10-12ms bei 100 Messungen
        rawValue += analogRead(ACS712_Pin0 + Channel);
      }
      float rawVoltage = (float)rawValue/Oversampling;
      float current = (rawVoltage - zeroCurrentValue[Channel])*5.0/1.024/0.185/1000; // für Module mit 185 mV/A
      bool fuse = current < currentfuse;
      read_zeroCurrentValue[0];
      if (current < 0) current = 0;
      TotalCurrent = TotalCurrent + current;
      /*
      if       (fuse)                                               {leds[Channel] = color4; ucg.setColor(typo4); }// Kurzschluss rot
      else if  ((current < current_a) && (zeroCurrentValue[0]>505)) {leds[Channel] = color1; ucg.setColor(typo1); }//       800mA@12V blau
      else if  (current < current_a)                                {leds[Channel] = color0; ucg.setColor(typo0); }//       800mA@5V  gruen
      else if  (current < current_b)                                {leds[Channel] = color2; ucg.setColor(typo2); }//      1200mA gelb
      else                                                          {leds[Channel] = color3; ucg.setColor(typo3); }//    >=1200mA rot 
*/
/* Dominik 2025-06-07 17:30
 *  Anpassung wegen Displaylatine
 *  zusätzliche 8 WS2812B
 * */
      if       (fuse)                                               {leds[Channel] = color4; leds[Channel+8] = color4; ucg.setColor(typo4); }// Kurzschluss rot
      else if  ((current < current_a) && (powersupply == 12))        {leds[Channel] = color0; leds[Channel+8] = color0; ucg.setColor(typo0); }// HLO changed; 800mA@12V blau
      else if  ((current < current_a) && (powersupply == 5))         {leds[Channel] = color1; leds[Channel+8] = color1; ucg.setColor(typo1); }// HLO changed; 800mA@5V gruen
      else if  (current < current_b)                                {leds[Channel] = color2; leds[Channel+8] = color2; ucg.setColor(typo2); }// 1200mA gelb
      else                                                          {leds[Channel] = color3; leds[Channel+8] = color3; ucg.setColor(typo3); }// >=1200mA rot 
     //Serial.print(F("Strom [A]: #")); Serial.print(Channel+1); Serial.print(": ");
/*      Serial.print("-200 200 "); // Konstanten damit skallirung fix ist
      Sum = Sum + current;
      if (Cnt++ == 400)
         {
         Avg = Sum / 400;
         Sum = 0; 
         Cnt = 0;
         }
      Serial.print(Avg);
      Serial.print(" ");
      Serial.println(current);     
*/     
      

      ucg.setFont(ucg_font_inb16_mr);
      //ucg.setColor(255, 255, 255);      
      //ucg.setColor(0, 255, 0);
      ucg.setColor(1,   0,0,0); // Hintergrundfarbe schwarz
      int Spalte = 0; // 0..1
      if (Channel > 3) Spalte = 1;
      int Zeile  = Channel % 4; // 0..3  "%" = Rest der Division: Beispiel Channel = 5 => 1
      ucg.setPrintPos(Spalte*82+11, 16+Zeile*27);
      char txt[10];
      dtostrf(current, 4, 2, txt);
      if (fuse)    ucg.print("Fuse");
      else         ucg.print(txt);
      ucg.setColor(255,255,255); // Hintergrundfarbe schwarz
      if (First) 
         {
         ucg.setFont(ucg_font_helvB08_hr);
         ucg.setPrintPos(Spalte*82+69, 16+Zeile*27);
         ucg.print("A");      
         ucg.setPrintPos(Spalte*83, 8+Zeile*27);
         ucg.print(Channel+1);
         }
         
     }
  if (First)
     {
     ucg.setPrintPos(0,115);
     ucg.print(supply1);
     ucg.setPrintPos(0,127);
     ucg.print(supply2);  // HLO
//     ucg.print(zeroCurrentValue[0]); // HLO Test entry 
/*     ucg.setPrintPos(144,114);
     ucg.print("1-8");
*/
     ucg.setPrintPos(151,127);
     ucg.print("A");
     }
  ucg.setFont(ucg_font_inb16_mr);
  char txt[10];
  dtostrf(TotalCurrent, 5, 2, txt);
  ucg.setPrintPos(79,127);
//  ucg.setColor(0,0,255);
  ucg.print(txt);
  First = false;
     
  //Serial.print("Disp:"); Serial.println(millis()-Start); //Debug
  FastLED.show(); 
  //Serial.print("  total: ");
  //Serial.println(TotalCurrent);
  
//  delay(2000);        
}
